<?php 
global $epcl_theme; 
$post_id = get_the_ID();
$post_format = get_post_format();
$post_style = '';
if( function_exists('get_field') && function_exists('get_fields') ){
    $fields = get_fields();
    $post_style = get_field('style');
    if( $post_style === '' ) $post_style = 'standard';
}
?>
<header>

    <div data-aos="fade">
	    <?php echo epcl_display_post_format( $post_format, $post_id ); ?>
    </div>

	<!-- start: .meta -->
	<div class="meta">
        <h1 class="title large no-thumb bold"><?php the_title(); ?></h1>
        <?php if( empty($epcl_theme) || $epcl_theme['single_enable_meta_data'] !== '0' ): ?>
            <div class="left grid-60 grid-parent">
                <time datetime="<?php the_time('Y-m-d'); ?>"><svg><use xlink:href="#calendar"></use></svg><?php the_time( get_option('date_format') ); ?></time>
                <a href="#comments" class="comments tooltip" title="<?php esc_attr_e('Go to comments', 'reco'); ?>">
                    <svg><use xlink:href="#comments-2"></use></svg>
                    <?php if($epcl_theme['hosted_comments'] == 1 || empty($epcl_theme) ): ?>
                        <span class="comment-count"><?php echo get_comments_number($post->ID); ?></span>
                        <span class="comment-text hide-on-mobile"><?php printf( _n( 'Comment', 'Comments', get_comments_number($post->ID), 'reco'), get_comments_number($post->ID) ); ?></span>
                    <?php else: ?>
                        <span class="disqus-comment-count" data-disqus-url="<?php the_permalink(); ?>" data-disqus-identifier="<?php the_ID(); ?>">0</span>
                    <?php endif; ?>
                </a>
                <?php if( isset($fields['enable_download']) && $fields['enable_download'] == true ): ?>
                    <?php if( function_exists('edd_get_download_sales_stats') && isset($fields['edd_download_id']) && $fields['edd_download_id'] ): ?>                  
                        <span class="download" title="<?php esc_attr_e('Downloads', 'reco'); ?>"><svg><use xlink:href="#download"></use></svg><?php echo esc_attr( edd_get_download_sales_stats( $fields['edd_download_id']) ); ?></span>
                    <?php else: ?>
                        <span class="download" title="<?php esc_attr_e('Downloads', 'reco'); ?>"><svg><use xlink:href="#download"></use></svg><?php echo esc_attr( $fields['download_counter' ]); ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>
		<div class="clear"></div>
	</div>
	<!-- end: .meta -->

	<div class="clear"></div>

</header>