<?php 
global $epcl_theme;
if( function_exists('get_field') && function_exists('get_fields') ){
    $fields = get_fields();
} 
$post_thumbnail = get_the_post_thumbnail_url($post, 'epcl_page_header');
?>
<div class="featured-image cover" style="background-image: url('<?php echo esc_url($post_thumbnail); ?>');">
    <?php if( empty($epcl_theme) || $epcl_theme['single_enable_meta_data'] !== '0' ): ?>
        <div class="meta top">
            <time datetime="<?php the_time('Y-m-d'); ?>"><svg><use xlink:href="#calendar"></use></svg><?php the_time( get_option('date_format') ); ?></time>
            <?php if( isset($fields['enable_download']) && $fields['enable_download'] == true ): ?>
                <?php if( function_exists('edd_get_download_sales_stats') && isset($fields['edd_download_id']) && $fields['edd_download_id'] ): ?>                  
                    <span class="download alignright" title="<?php esc_attr_e('Downloads', 'reco'); ?>"><svg><use xlink:href="#download"></use></svg><?php echo esc_attr( edd_get_download_sales_stats( $fields['edd_download_id']) ); ?></span>
                <?php else: ?>
                    <span class="download alignright" title="<?php esc_attr_e('Downloads', 'reco'); ?>"><svg><use xlink:href="#download"></use></svg><?php echo esc_attr( $fields['download_counter' ]); ?></span>
                <?php endif; ?>
            <?php endif; ?>
            <a href="<?php the_permalink(); ?>#comments" class="comments tooltip" title="<?php esc_attr_e('Go to comments', 'reco'); ?>">
                <svg><use xlink:href="#comments-2"></use></svg>
                <?php if($epcl_theme['hosted_comments'] == 1 || empty($epcl_theme) ): ?>
                    <span class="comment-count"><?php echo get_comments_number($post->ID); ?></span>
                    <span class="comment-text hide-on-mobile"><?php printf( _n( 'Comment', 'Comments', get_comments_number($post->ID), 'reco'), get_comments_number($post->ID) ); ?></span>
                <?php else: ?>
                    <span class="disqus-comment-count" data-disqus-url="<?php the_permalink(); ?>" data-disqus-identifier="<?php the_ID(); ?>">0</span>
                <?php endif; ?>
            </a>
        </div>
    <?php endif; ?>
	<div class="info">
        <?php if( get_the_category() ): ?>
            <div class="tags">
                <?php the_category(' '); ?>
            </div>
        <?php endif; ?>
        <h1 class="title ularge white bold"><?php the_title(); ?></h1>
	</div>
</div>