<?php
global $epcl_theme, $epcl_module;
// ACF custom builder
if( is_page_template('page-templates/home.php') ){
	$var = is_front_page() ? 'page' : 'paged';
	$paged = ( get_query_var($var) ) ? get_query_var($var) : 1;
	$args = array('post_type' => 'post', 'paged' => $paged);
	if( !empty($epcl_module) && isset($epcl_module['classic_category']) && $epcl_module['classic_category'] != '' ){
		$args['cat'] = $epcl_module['classic_category'];
	}
	$wp_query = new WP_Query($args);
}
add_filter( 'excerpt_length', 'epcl_large_excerpt_length', 999 );
$module_class = '';
if( !empty($epcl_module) ){
	if( $epcl_module['enable_counter'] == false ){
		$module_class .= ' no-counter';
	}
	if( $epcl_module['enable_filters'] == false ){
		$module_class .= ' no-filters';
	}
}
if( !is_active_sidebar('epcl_sidebar_home') ){
    $module_class .= ' no-active-sidebar';
}
if( !empty($epcl_theme) && $epcl_theme['enable_global_counter'] == false){
    $module_class .= ' no-counter';
}
?>

<div class="grid-container module-wrapper <?php echo esc_attr($module_class); ?>">
    <?php if( $epcl_module['enable_counter'] !== false && $epcl_theme['enable_global_counter'] == '1' ): ?>
        <div class="section">
            <?php $total_posts = wp_count_posts(); ?>
            <?php if(is_home() || is_front_page() ): ?>
                <?php if( $epcl_theme['counter_text'] != '' ): ?>
                    <h2 class="title ularge white textcenter no-margin"><?php echo str_replace('%s', '<span class="count main-color" data-total="'.intval($total_posts->publish).'">0</span>', $epcl_theme['counter_text'] ); ?></h2>
                <?php else: ?>
                    <h2 class="title ularge white textcenter no-margin"><?php esc_html_e('Hello! We have', 'reco'); ?> <span class="count main-color" data-total="<?php echo intval($total_posts->publish); ?>">0</span> <?php printf( esc_html_e( _n( 'resource for you...', 'resources for you...', intval($total_posts->publish), 'reco' ), intval($total_posts->publish) ) ); ?></h2>
                <?php endif; ?>
            <?php else: ?>
                <?php if( !empty($epcl_theme) && $epcl_theme['counter_text_archives'] != '' ): ?>
                        <h2 class="title ularge white textcenter no-margin"><?php echo str_replace('%s', '<span class="count main-color" data-total="'.intval($wp_query->found_posts).'">0</span>', $epcl_theme['counter_text_archives'] ); ?></h2>
                <?php else: ?>
                    <h2 class="title ularge white textcenter no-margin"><?php esc_html_e('We found', 'reco'); ?> <span class="count main-color" data-total="<?php echo intval($wp_query->found_posts); ?>">0</span> <?php printf( esc_html_e( _n( 'resource for you...', 'resources for you...', intval($wp_query->found_posts), 'reco' ), intval($wp_query->found_posts) ) ); ?></h2>
                <?php endif; ?>
            <?php endif; ?>
            <div class="clear"></div>
        </div>
    <?php endif; ?>

	<?php if( $epcl_module['enable_filters'] !== false): ?>
        <?php get_template_part('partials/filters'); ?>
    <?php endif; ?>

    <!-- start: .content-wrapper -->
    <div class="content-wrapper classic">
        <div class="content clearfix">
            <!-- start: .center -->
            <div class="center left-content grid-70">

                <?php if( have_posts() ): ?>
                    <!-- start: .articles -->
                    <div class="articles classic">
                        <?php while( have_posts() ): the_post(); ?>
                            <?php get_template_part('partials/loops/classic-article'); ?>
                        <?php endwhile; ?>
                    </div>
                    <!-- end: .articles -->
                    <?php epcl_pagination(); ?>

                    <?php wp_reset_query(); ?>

                <?php else: ?>

                    <!-- start: .articles -->
                    <div class="articles classic">
                        <div class="section">
                            <div class="text textcenter">
                                <h3 class="title large no-margin"><?php esc_html_e("Something's wrong here...", 'reco'); ?></h3>
                                <p><?php esc_html_e("We can't find any result for your search term.", 'reco'); ?></p>
                            </div>
                            <div class="buttons textcenter">
                                <a href="<?php echo site_url(); ?>" class="button outline"><i class="fa fa-share fa-flip-horizontal"></i> <?php esc_html_e("Go back to home", "reco"); ?></a>
                            </div>
                        </div>
                    </div>
                    <!-- end: .articles -->

                <?php endif; ?>

            </div>
            <!-- end: .center -->
            <?php get_sidebar(); ?>
        </div>
    </div>
    <!-- end: .content-wrapper -->
</div>