<?php
global $epcl_theme;
if( function_exists('icl_get_home_url') ) $home = icl_get_home_url();
else $home = site_url();
// Just demo
if( isset($_GET['header']) ){
	$header_type = sanitize_text_field( $_GET['header'] );
	switch($header_type){
		default:
			$epcl_theme['header_type'] = 'minimalist';
		break;
		case 'classic':
			$epcl_theme['header_type'] = 'classic';
		break;
		case 'notice':
			$epcl_theme['enable_notice'] = true;
        break;
        case 'advertising':
            $epcl_theme['header_type'] = 'advertising';
		break;
	}
}

$header_class = $epcl_theme['header_type'];
if( $epcl_theme['enable_sticky_header'] != false ){
	$header_class .=' enable-sticky';
}
if( $epcl_theme['sticky_logo_image']['url'] ){
    $header_class .=' has-sticky-logo'; 
}
?>
<?php if( $epcl_theme['enable_notice']  == true && $epcl_theme['notice_text'] ): ?>
    <div class="notice text underline-effect">
    	<div class="grid-container">
            <div class="info">
                <i class="fa fa-bell"></i>
                <?php echo wpautop( do_shortcode( $epcl_theme['notice_text'] ) ); ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- start: #header -->
<header id="header" class="<?php echo esc_attr($header_class); ?>">

	<div class="menu-mobile">
		<i class="fa fa-bars"></i>
	</div>

	<!-- start: .menu-wrapper -->
	<div class="menu-wrapper">
		<div class="grid-container">
            
			<?php if( $epcl_theme['logo_type'] == 1 && $epcl_theme['logo_image']['url'] ): ?>
                <div class="logo">
                    <a href="<?php echo site_url(); ?>"><img src="<?php echo esc_url( $epcl_theme['logo_image']['url'] ); ?>" alt="<?php bloginfo('name'); ?>" width="<?php echo esc_attr( $epcl_theme['logo_width'] ); ?>" /></a>
                </div>
                <?php if( $epcl_theme['sticky_logo_image']['url'] ): ?>
                    <div class="logo sticky-logo">
                        <a href="<?php echo site_url(); ?>"><img src="<?php echo esc_url( $epcl_theme['sticky_logo_image']['url'] ); ?>" alt="<?php bloginfo('name'); ?>" width="<?php echo esc_attr( $epcl_theme['sticky_logo_width'] ); ?>" /></a>
                    </div>                
                <?php endif; ?>
			<?php else: ?>
				<div class="logo">
					<a href="<?php echo site_url(); ?>" class="title white no-margin">
						<?php if($epcl_theme['logo_icon']): ?>
							<i class="fa <?php echo esc_attr( $epcl_theme['logo_icon'] ); ?>"></i>
						<?php endif; ?>
						<?php bloginfo('name'); ?>
					</a>
				</div>
            <?php endif; ?>

            <?php if( $epcl_theme['header_type'] == 'advertising' && function_exists('epcl_render_header_ads') ): ?>
                <?php epcl_render_header_ads(); ?>
            <?php endif; ?>

            <?php if( $epcl_theme['enable_share_header'] || function_exists('edd_get_checkout_uri') ): ?>
                <div class="share-buttons hide-on-tablet hide-on-mobile">
                    <?php if( function_exists('edd_get_checkout_uri') ): ?>
                        <a href="<?php echo esc_url( edd_get_checkout_uri() ); ?>">
                            <i class="fa fa-shopping-cart"></i>
                            <span class="header-cart edd-cart-quantity"><?php echo edd_get_cart_quantity(); ?></span>
                        </a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['facebook_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['facebook_url'] ); ?>" target="_blank"><i class="fa fa-facebook"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['twitter_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['twitter_url'] ); ?>" target="_blank"><i class="fa fa-twitter"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['linkedin_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['linkedin_url'] ); ?>" target="_blank"><i class="fa fa-linkedin"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['instagram_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['instagram_url'] ); ?>" target="_blank"><i class="fa fa-instagram"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['pinterest_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['pinterest_url'] ); ?>" target="_blank"><i class="fa fa-pinterest"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['dribbble_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['dribbble_url'] ); ?>" target="_blank"><i class="fa fa-dribbble"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['tumblr_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['tumblr_url'] ); ?>" target="_blank"><i class="fa fa-tumblr"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['youtube_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['youtube_url'] ); ?>" target="_blank"><i class="fa fa-youtube"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['flickr_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['flickr_url'] ); ?>" target="_blank"><i class="fa fa-flickr"></i></a>
                    <?php endif; ?>
                    <?php if( $epcl_theme['rss_url'] ): ?>
                        <a href="<?php echo esc_url( $epcl_theme['rss_url'] ); ?>" target="_blank"><i class="fa fa-rss"></i></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            
			<!-- start: .main-nav -->
			<nav class="main-nav">
				<?php
				$args = array(
					'theme_location' => 'epcl_header',
					'container' => false
				);
				if(has_nav_menu('epcl_header')){
					wp_nav_menu($args);
				}
				?>
			</nav>
            <!-- end: .main-nav -->

            <div class="clear"></div>
            <div class="border hide-on-tablet hide-on-mobile"></div>
		</div>
		<div class="clear"></div>
	</div>
	<!-- end: .menu-wrapper -->

	<div class="clear"></div>
</header>
<!-- end: #header -->

<?php
if( function_exists( 'epcl_render_global_ads' ) ){
	epcl_render_global_ads('below_header');
}
?>
