<?php
/*
* Functions just for this particular theme
*
*/

/* Move comments fields to the bottom */

function epcl_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;

	return $fields;
}

add_filter( 'comment_form_fields', 'epcl_move_comment_field_to_bottom' );

/* Ajax for download button */

function epcl_download() {

    $nonce = $_POST['nonce'];
    
	
    if ( ! wp_verify_nonce( $nonce, 'epcl_download' ) )
        die ( 'Busted!');

    $post_id = sanitize_text_field( $_POST['post_id'] );    

    $download_counter = get_post_meta($post_id, 'download_counter', true);
    if( !$download_counter ) $download_counter = 0;

    update_post_meta($post_id, 'download_counter', ++$download_counter);

    die('success');
}
add_action('wp_ajax_nopriv_epcl_download', 'epcl_download');
add_action('wp_ajax_epcl_download', 'epcl_download');

/* Add small excerpt length */

function epcl_small_excerpt_length($length){
    global $epcl_theme;
    $length = 17;

    if( !empty($epcl_theme) && $epcl_theme['small_excerpt_length'] ){
        $length = absint( $epcl_theme['small_excerpt_length'] );
    }
	return $length;
}

function epcl_large_excerpt_length($length){
    global $epcl_theme;
    $length = 30;

    if( !empty($epcl_theme) && $epcl_theme['large_excerpt_length'] ){
        $length = absint( $epcl_theme['large_excerpt_length'] );
    }
	return $length;
}

/* Custom Pagination */

function epcl_pagination($query = NULL){
	global $wp_query, $paged;
    if($query) $wp_query = $query;
    if( !empty($wp_query->query['paged']) ){
        $paged = $wp_query->query['paged'];
    }
    
?>
    <div class="separator last hide-on-tablet hide-on-mobile"></div>
    <div class="clear"></div>
    <!-- start: .pagination -->
    <div class="pagination section">
        <div class="nav">
            <?php echo get_previous_posts_link( esc_html__('Previous', 'reco') ); ?>
            <span class="page-number">
                <?php if( is_rtl() ): ?>
                    <?php echo intval($wp_query->max_num_pages); ?> <?php esc_html_e('of', 'reco'); ?>
                    <?php echo max(1, get_query_var('paged') ); ?> <?php esc_html_e('Page', 'reco'); ?>                     
                <?php else: ?>
                    <?php esc_html_e('Page', 'reco'); ?> <?php echo max(1, get_query_var('paged') ); ?>
                    <?php esc_html_e('of', 'reco'); ?> <?php echo intval($wp_query->max_num_pages); ?>
                <?php endif; ?>
            </span>
            <?php echo get_next_posts_link( esc_html__('Next', 'reco') ); ?>
        </div>
    </div>
    <!-- end: .pagination -->
<?php
}

add_filter( 'image_size_names_choose', 'epcl_media_settings_custom_sizes' );

function epcl_media_settings_custom_sizes( $sizes ) {
	return array_merge( $sizes, array(
		'epcl_single_content' => esc_html__( 'EP Article Thumb', 'reco' ),
	) );
}

add_filter('wp_list_categories', 'epcl_at_count_span');
add_filter('get_archives_link', 'epcl_archives_count');

function epcl_at_count_span($links) {
    $links = str_replace('</a> (', '</a> <span>(', $links);
    $links = str_replace(')', ')</span>', $links);
    return $links;
}

function epcl_archives_count($links){
    $links = str_replace('</a>&nbsp;(', '</a> <span>(', $links);
    $links = str_replace(')', ')</span>', $links);
    return $links;
}

?>
