<?php

/* Scripts and Styles */

if( !function_exists('epcl_enqueue_scripts') ){

	add_action('wp_enqueue_scripts', 'epcl_enqueue_scripts');

	function epcl_enqueue_scripts() {
		global $epcl_theme;

		$assets_folder = EPCL_THEMEPATH.'/assets';
        $prefix = EPCL_THEMEPREFIX.'-';
        $ver = '2.8.0';
        

        /* Styles */

        wp_register_style($prefix.'theme', $assets_folder.'/dist/style.min.css', NULL, $ver);
        wp_register_style($prefix.'plugins', $assets_folder.'/dist/plugins.min.css', NULL, NULL);
        wp_register_style($prefix.'google-fonts', 'https://fonts.googleapis.com/css?family=Roboto:400,500,700|Poppins:400,400i,500,600,600i,700,700i', NULL, NULL);
        
        wp_enqueue_style($prefix.'theme');
        wp_enqueue_style($prefix.'plugins');
        wp_enqueue_style($prefix.'google-fonts');

        if( !defined('W3TC') ){
            $custom_css = epcl_generate_custom_styles();
            wp_add_inline_style( $prefix.'theme', $custom_css );
        }

        /* Scripts */
        
        // W3 Total Cache optimization

        if( !empty($epcl_theme) && $epcl_theme['move_jquery_footer'] ){ // Only enabled by panel
            wp_scripts()->add_data( 'jquery', 'group', 1 );
            wp_scripts()->add_data( 'jquery-core', 'group', 1 );
            wp_scripts()->add_data( 'jquery-migrate', 'group', 1 );
        }

		wp_enqueue_script($prefix.'scripts', $assets_folder.'/dist/scripts.min.js', array('jquery'), $ver, true);

		if( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1) ) {
			wp_enqueue_script( 'comment-reply', 'wp-includes/js/comment-reply', array(), false, true );
        }

        // Disqus inline JS

        if( !empty($epcl_theme) && $epcl_theme['hosted_comments'] == 2 && $epcl_theme['disqus_id'] ){
            $custom_js = epcl_add_disqus_scripts();
            wp_add_inline_script($prefix.'scripts', $custom_js);
        }
        
        /* Ajax */
	
		wp_localize_script($prefix.'scripts', 'ajax_var', array(
			'url' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('epcl_download')
		));

    }

    function epcl_add_disqus_scripts(){
        global $epcl_theme;

        $js = 
        '
        var disqus_shortname = "'.esc_attr( $epcl_theme['disqus_id']).'";
        
        !function(){var e=document.createElement("script");e.async=!0,e.type="text/javascript",e.src="//"+disqus_shortname+".disqus.com/count.js",document.getElementsByTagName("BODY")[0].appendChild(e)}();
        ';
        if( is_single() ){
        	$js .= '
	        var disqus_config = function () {
	            this.page.url = "'.get_the_permalink().'"; 
	            this.page.identifier = "'.get_the_ID().'";
	        };
	        (function() { 
	            var d = document, s = d.createElement("script");
	            s.src = "//" + disqus_shortname + ".disqus.com/embed.js";
	            s.setAttribute("data-timestamp", +new Date());
	            (d.head || d.body).appendChild(s);
	        })();';
        }
        return $js;
            
    }
    
}

?>
